package org.msh.etbm.services.mobile.sync;

import org.msh.etbm.services.mobile.model.CaseSideEffectData;
import org.msh.etbm.services.mobile.model.ContactData;
import org.msh.tb.entities.CaseSideEffect;
import org.msh.tb.entities.TbCase;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.ng.entities.TbContactNG;

/**
 * Created by rmemoria on 14/9/17.
 */
public class CaseSideEffectConsumer extends SyncDataConsumerImpl<CaseSideEffectData, Integer> {

    @Override
    public Integer consume(Tbunit unit, CaseSideEffectData data) {
        CaseSideEffect sideEffect = recoverEntity(CaseSideEffect.class, data.getServerId());

        if (sideEffect.getId() == null) {
            TbCase tbcase = getEntityManager().find(TbCase.class, data.getCaseId());
            sideEffect.setTbcase(tbcase);
        }

        sideEffect.setSideEffect(getFieldValueComponent(data.getSideEffect()));
        sideEffect.setSubstance(getSubstance(data.getSubstance()));
        sideEffect.setSubstance2(getSubstance(data.getSubstance2()));
        sideEffect.setMonth(data.getMonth());
        sideEffect.setComment(data.getComments());

        getEntityManager().persist(sideEffect);

        return data.getServerId() == null ? sideEffect.getId() : null;
    }
}
